## Importing functionality from Java

Java interfaces and classes can be imported from Java by declaring them inside `importJava` block:

~~~
importJava "java.util.regex.Pattern" where
    data Pattern

importJava "java.util.List" where
    data List a
~~~

Java methods, constructors and fields can be similarly imported by giving
their type annotations in `importJava` block:

~~~
importJava "java.util.regex.Pattern.compile" where
    @JavaName compile
    compilePattern :: String -> Pattern

    @JavaName matcher
    createMatcher :: Pattern -> String -> <Proc> Matcher

importJava "java.util.regex.Matcher" where
    data Matcher

    @JavaName matches
    matcherMatches :: Matcher -> <Proc> Boolean

matches : Pattern -> String -> <Proc> Boolean
matches pattern text = do
    matcherMatches (createMatcher pattern text)
~~~

Another example:

~~~
importJava "java.util.ArrayList" where
    @JavaName "<init>"
    createArrayList :: () -> <Proc> List a

    @JavaName "<init>"
    createArrayListWithCapacity :: Integer -> <Proc> List a

    @JavaName size
    sizeList :: List a -> <Proc> Integer

    @JavaName get
    getList :: List a -> Integer -> <Proc> a

    @JavaName set
    setList :: List a -> Integer -> a -> <Proc> ()

    @JavaName add
    addList :: List a -> a -> <Proc> Boolean
~~~

Java constructor is referred with `"<init>"`. If Java method name and SCL name matches the annotation `@JavaName`
can be left out. Java import mechanism tries to be quite flexible. It provides some arguments based on the effects
the function has. It also ignores the return value of the Java method if the return type is `()` in SCL. 

A major functionality currently still missing is the ability to create new implementations of existing Java interfaces
in SCL code or extend an existing class. This can be worked around currently by writing new implementations in Java.

## Relational sublanguage 

* Select, when, enforce
* Transformations

## Other language features

* Defining data types
* Defining type classes
* Defining effects 
* Restricted imports
* Documentation strings
* Private definitions
* Binary operator precedence

